/**********
* File: DXGraphicsMathUtils.h

* Brief Description: This file contains functions decalrations used by the DirectX extensions math utility functions.
These functions are those which are required by the DirectX math utilities but cannot 
be included in DXGL_Math.cpp.

* Written By: Sharathchandra Bhagawath.

* Copyright: 1994-2004 by Robosoft Technologies, all rights reserved.

* Date Of Creation: 24th March 2005.

* Change History (Most Recent First):

*/

#ifndef _DXGRAPHICSMATHUTILS_H_
#define _DXGRAPHICSMATHUTILS_H_

/// DirectX include files..
#ifdef DXGRAPHICS_VERSION8
#include "d3dx8math.h"
#endif
#ifdef DXGRAPHICS_VERSION9
#include "d3dx9math.h"
#endif
//#include "CDGL_ID3DXMatrixStack.h"

/// Application specific include files..
#include "DXGraphicsQuat.h"


typedef union
{
	float	value[16];
//DMA@robosoftin.com
#if !TARGET_CPU_PPC
#ifdef __BIG_ENDIAN__	
	vector float v[4];
#endif	
#endif
}OGLMatrix4x4;

typedef GLfloat GLTMatrix[16];      // A column major 4x4 matrix of type GLfloat

void OGLMatrix4x4_Multiply_Altivec(const OGLMatrix4x4	*mA, const OGLMatrix4x4 *mB, OGLMatrix4x4	*result);

D3DXQUATERNION mult(D3DXQUATERNION A, D3DXQUATERNION B);

D3DXVECTOR4 * MultiplyVectorWithMatrix(D3DXVECTOR4 *out_VectorProductOfVectorAndMatrix,CONST D3DXVECTOR4 *in_TransVector, CONST D3DXMATRIX *in_TransMatrix);


bool IsPowerOf2(UInt32 n);

UInt32 NextPowerOf2(UInt32 n);



#endif //_DXGRAPHICSMATHUTILS_H_

